<?php
/**
* @version $Id: mod_jdownloads_admin_monitoring.php v4.1.0
* @package mod_jdownloads_admin_monitoring
* @copyright (C) 2025 Arno Betz
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @author Arno Betz http://www.jDownloads.com
*/

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

use JDownloads\Component\JDownloads\Administrator\Helper\JDownloadsHelper;

HTMLHelper::_('bootstrap.tooltip');

// Load Bootstrap Modal
HTMLHelper::_('bootstrap.modal');

// Register JavaScript for Modal handling
$wa = $app->getDocument()->getWebAssetManager();
$wa->useScript('bootstrap.modal');
    
    $canDo  = JDownloadsHelper::getActions();
    $app    = Factory::getApplication();
    $user   = $app->getIdentity();
    
    // Get the secret key then we need it as link param
    // So nobody else outside can run the script (or he know the key value - e.g. to start it via a cronjob)
    $config = $app->getConfig();
    $key    = $params->get('scan_secret_key');                         
    $test   = (int)$params->get('use_first_testrun');

    $url = 'index.php?option=com_config&view=component&component=com_jdownloads#monitoring';
    
    // Unique ID for modal
    $modalId = 'jdMonitoringModal-' . substr(md5(uniqid()), 0, 8);
    ?>
    <div class="accordion" id="accordionPanels">
        <div class="accordion-item">
            <h2 class="accordion-header" id="panelsStayOpen-headingOne">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="false" aria-controls="panelsStayOpen-collapseOne">
                    <?php echo Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_DESC_LONG_LABEL'); ?>
                </button>
            </h2>
        </div>
        <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingOne">
            <div class="accordion-body">
                <div>
                    <?php echo Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_DESC_LONG'); ?>
                </div>    
            </div>
        </div>
    </div>
        
    <div class="alert alert-info">    
        <div style="margin-top:15px;">
            <!-- Single Button to Open Monitoring Modal -->
            <button class="btn btn-primary jd-monitoring-modal-link" 
                    href="#" 
                    data-mode="0" 
                    data-test="<?php echo (int)$test; ?>">
                <i class="icon-play"></i> 
                <?php echo Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_BUTTON_TEXT'); ?>
            </button>
        </div>
        <div style="margin-top:11px;">                                        
            <?php echo '<small>'.Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_RUN_MONITORING_INFO').'</small>'; ?>
            <?php echo '<ul>';
                  
                if ($test) {
                    echo '<li><small>'.Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_TEST_RUN_ACTIVE_HINT').'</small></li>'; 
                }
                  
                if (!$params->get('all_folders_autodetect')) {
                    echo '<li><small>'.Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_EXCLUDE_INCLUDE_OPTION_IS_ACTIVE_HINT').'</small></li>'; 
                }
                  
                if ($params->get('autopublish_founded_files')) {
                    echo '<li><small>'.Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_AUTO_PUBLISH_NEW_FOUND_ITEMS_HINT').'</small></li>'; 
                }
                  
                if ($params->get('autopublish_use_cat_default_values')) {
                    echo '<li><small>'.Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_AUTO_PUBLISH_USE_DEFAULT_CAT').'</small></li>'; 
                }
                
                if ($params->get('autopublish_use_default_values')) {
                    echo '<li><small>'.Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_AUTO_PUBLISH_USE_DEFAULT_FILE').'</small></li>'; 
                }
                
                if ($params->get('compare_also_files_hash')) {
                    echo '<li><small>'.Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_COMPARE_FILE_HASH_HINT').'</small></li>'; 
                }
                
                if ($params->get('update_modification_date')) {
                    echo '<li><small>'.Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_UPDATE_MODIFIED_DATE_HINT').'</small></li>'; 
                }
                
                if ($params->get('update_update_status')) {
                    echo '<li><small>'.Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_UPDATE_UPDATE_STATUS_HINT').'</small></li>'; 
                }
                  
                echo '</ul>';
                
                if ($user->authorise('core.admin', 'com_jdownloads') || $user->authorise('core.options', 'com_jdownloads')) {
                    echo '<a href="' . $url . '" class="badge bg-warning">' . Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_CHANGE_OPTIONS') . '</a>';
                }  
            ?>
        </div>
    </div>

<!-- Bootstrap Modal for Monitoring -->
<div class="modal fade" id="<?php echo $modalId; ?>" tabindex="-1" aria-labelledby="<?php echo $modalId; ?>Label" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="<?php echo $modalId; ?>Label">
                    <i class="icon-eye"></i> <?php echo Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_MODAL_TITLE'); ?>
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <div id="<?php echo $modalId; ?>-loader" class="text-center p-5">
                    <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-3"><?php echo Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_LOADING'); ?></p>
                </div>
                <iframe id="<?php echo $modalId; ?>-iframe" 
                        style="width: 100%; height: 70vh; border: none; display: none;"
                        title="<?php echo Text::_('MOD_JDOWNLOADS_ADMIN_MONITORING_MODAL_TITLE'); ?>">
                </iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="icon-cancel"></i> <?php echo Text::_('JCLOSE'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<script>
(function() {
    'use strict';
    
    const modalId = '<?php echo $modalId; ?>';
    const secretKey = '<?php echo $key; ?>';
    const baseUrl = '<?php echo Uri::base(); ?>components/com_jdownloads/helpers/scan.php';
    
    document.addEventListener('DOMContentLoaded', function() {
        const modalElement = document.getElementById(modalId);
        const modal = new bootstrap.Modal(modalElement);
        const iframe = document.getElementById(modalId + '-iframe');
        const loader = document.getElementById(modalId + '-loader');
        const modalTitle = document.getElementById(modalId + 'Label');
        
        // Add click handlers to all modal links
        document.querySelectorAll('.jd-monitoring-modal-link').forEach(function(link) {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                
                const mode = this.dataset.mode;
                const test = this.dataset.test || '0';
                const modeName = this.textContent.trim();
                
                // Build URL - use new scan-interface.php
                const url = baseUrl.replace('scan.php', 'scan-interface.php') + 
                           '?mode=' + encodeURIComponent(mode) + 
                           '&test=' + encodeURIComponent(test);
                
                // Update modal title
                modalTitle.innerHTML = '<i class="icon-eye"></i> ' + modeName;
                
                // Show loader, hide iframe
                loader.style.display = 'block';
                iframe.style.display = 'none';
                iframe.src = '';
                
                // Show modal
                modal.show();
                
                // Load iframe after a short delay
                setTimeout(function() {
                    iframe.src = url;
                    
                    // Hide loader when iframe loads
                    iframe.addEventListener('load', function() {
                        loader.style.display = 'none';
                        iframe.style.display = 'block';
                    }, { once: true });
                }, 100);
            });
        });
        
        // Reset iframe when modal is closed
        modalElement.addEventListener('hidden.bs.modal', function() {
            iframe.src = '';
            loader.style.display = 'block';
            iframe.style.display = 'none';
            // Fix aria-hidden focus issue
            modalElement.removeAttribute('aria-hidden');
        });
        
        // Prevent aria-hidden focus issues
        modalElement.addEventListener('show.bs.modal', function() {
            modalElement.removeAttribute('aria-hidden');
        });
    });
})();
</script>

<style>
/* Custom styles for modal */
#<?php echo $modalId; ?> .modal-xl {
    max-width: 900px;
    width: 95%;
}

#<?php echo $modalId; ?> .modal-body {
    padding: 0;
}

#<?php echo $modalId; ?>-loader {
    background: #f8f9fa;
}

/* Ensure dropdown stays on top */
.dropdown-menu {
    z-index: 1050;
}

/* Fix: Blocked aria-hidden on an element because its descendant retained focus */
.modal[aria-hidden="true"] {
    display: none !important;
}

.modal[aria-hidden="true"] * {
    visibility: hidden;
}
</style>
