<?php
/**
 * @copyright    Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license      GNU General Public License version 2 or later; see LICENSE.txt
 */

/**
 * @package jDownloads
 * @version 4.0  
 * @copyright (C) 2007 - 2022 - Arno Betz - www.jdownloads.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.txt
 * 
 * jDownloads is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

namespace JDownloads\Component\JDownloads\Administrator\Field;

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\Field\TextField;

class JDMaxFileSizeConfigField extends TextField
{
     /**
     * The form field type.
     *
     * @var string
     */
     protected $type = 'JDMaxFileSizeConfig';

    protected function getInput()
    {
        $input = parent::getInput();
        $description = Text::_('COM_JDOWNLOADS_UPLOAD_MAX_FILESIZE_INFO_TITLE');
        $max_size = ini_get('upload_max_filesize');
        $text = $description . ' ' . $max_size;

        return $input . '<div class="form-text">' . htmlspecialchars($text, ENT_QUOTES, 'UTF-8') . '</div>';
    }
}    
?>