<?php
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_FILES['file'])) {
    echo json_encode(['success' => false]);
    exit;
}

$file = $_FILES['file'];
if ($file['error'] !== 0) {
    echo json_encode(['success' => false, 'error' => 'Upload error']);
    exit;
}

// Try to load Joomla params
$uploadDir = dirname(__FILE__) . '/../../test_uploads';
$maxSize = 512 * 1024 * 1024;
$allowedTypes = ['zip', 'rar', '7z', 'tar', 'gz', 'pdf', 'exe', 'msi', 'dat', 'mp3', 'mp4', 'jpg', 'jpeg', 'png', 'gif', 'txt', 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx'];

try {
    // Calculate Joomla root: from /administrator/components/com_jdownloads/assets/upload/ go up 5 levels
    $joomlaRoot = dirname(__FILE__);
    for ($i = 0; $i < 5; $i++) {
        $joomlaRoot = dirname($joomlaRoot);
    }
    
    $definesFile = $joomlaRoot . '/includes/defines.php';
    $bootstrapFile = $joomlaRoot . '/libraries/bootstrap.php';
    
    if (file_exists($definesFile) && file_exists($bootstrapFile)) {
        // Define _JEXEC BEFORE loading anything
        defined('_JEXEC') or define('_JEXEC', 1);
        require_once($definesFile);
        require_once($bootstrapFile);
        
        if (defined('_JEXEC')) {
            $params = \Joomla\CMS\Component\ComponentHelper::getParams('com_jdownloads');
            
            // Get upload directory from params
            $paramDir = $params->get('files_uploaddir');
            if ($paramDir) {
                // Ensure absolute path
                if (strpos($paramDir, JPATH_SITE) === false) {
                    $uploadDir = JPATH_SITE . '/' . ltrim($paramDir, '/');
                } else {
                    $uploadDir = $paramDir;
                }
            }
            
            $maxSizeStr = $params->get('file_max_upload_size', '512M');
            if (preg_match('/(\d+)([KMGT])?/i', $maxSizeStr, $m)) {
                $mult = ['K' => 1024, 'M' => 1048576, 'G' => 1073741824, 'T' => 1099511627776];
                $maxSize = (int)$m[1] * ($mult[strtoupper($m[2] ?? '')] ?? 1);
            }
            $typesStr = $params->get('file_types_upload', '');
            if ($typesStr) {
                $allowedTypes = array_map('trim', explode(',', $typesStr));
            }
        }
    }
} catch (Exception $e) {
   // Fallback to defaults
}@mkdir($uploadDir, 0755, true);

if ($file['size'] > $maxSize) {
    echo json_encode(['success' => false, 'error' => 'File too large']);
    exit;
}

// Check file type
$ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
if (!in_array($ext, $allowedTypes)) {
    echo json_encode(['success' => false, 'error' => 'File type not allowed']);
    exit;
}

if (!move_uploaded_file($file['tmp_name'], $uploadDir . '/' . time() . '_' . basename($file['name']))) {
    echo json_encode(['success' => false, 'error' => 'Move failed']);
    exit;
}

echo json_encode(['success' => true, 'size' => $file['size']]);