<?php
/**
 * @package jDownloads
 * @version 4.1
 * @copyright (C) 2007 - 2026
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

namespace JDownloads\Component\JDownloads\Site\Helper;

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class DownloadsPlgHelper
{
    /**
     * Get downloads for one or more categories.
    *
    * Kurzbeispiel:
    * $items = DownloadsPlgHelper::getDownloadsByCategories([12, 34], [
    *     'ordering' => 'a.downloads',
    *     'direction' => 'DESC',
    *     'limit' => 50,
    * ]);
     *
     * @param int|int[] $categoryIds Category id or list of ids.
     * @param array     $options     Optional filters and list settings.
     *
     * @return array
     */
    public static function getDownloadsByCategories($categoryIds, array $options = [])
    {
        $app = Factory::getApplication();

        $model = $app->bootComponent('com_jdownloads')
            ->getMVCFactory()
            ->createModel('Downloads', 'Site', ['ignore_request' => true]);

        $ids = is_array($categoryIds) ? $categoryIds : [(int) $categoryIds];

        $model->setState('filter.category_id', $ids);
        $model->setState('filter.category_id.include', true);

        $model->setState('filter.published', $options['published'] ?? 1);
        $model->setState('filter.access', true);
        $model->setState('filter.user_access', true);

        $model->setState('list.ordering', $options['ordering'] ?? 'a.created');
        $model->setState('list.direction', $options['direction'] ?? 'DESC');
        $model->setState('list.start', (int) ($options['start'] ?? 0));
        $model->setState('list.limit', (int) ($options['limit'] ?? 0));

        return $model->getItems();
    }
}
